<div class="row justify-content-center">
    <div class="col-md-8 text-center">
        <h1 class="display-4 mb-4">Welcome to BookLinks</h1>
        <p class="lead">The ultimate landing page solution for book authors</p>
        <p class="mb-5">Create beautiful, customizable landing pages for your books and share them with your readers. Organize your purchase links, connect with your audience, and boost your book sales.</p>
        
        <?php if (!isLoggedIn()): ?>
            <div class="my-5">
                <a href="<?php echo APP_URL; ?>/pages/register.php" class="btn btn-primary btn-lg me-3">Get Started</a>
                <a href="<?php echo APP_URL; ?>/pages/login.php" class="btn btn-outline-secondary btn-lg">Login</a>
            </div>
        <?php else: ?>
            <div class="my-5">
                <a href="<?php echo APP_URL; ?>/pages/dashboard.php" class="btn btn-primary btn-lg">Go to Dashboard</a>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="row mt-5 mb-5">
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <i class="fas fa-link fa-3x mb-3 text-primary"></i>
                <h3>One Link for All Platforms</h3>
                <p>Consolidate all your book's purchase links into one simple, memorable URL</p>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <i class="fas fa-palette fa-3x mb-3 text-primary"></i>
                <h3>Fully Customizable</h3>
                <p>Personalize your page with your brand colors, book covers, and description</p>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card h-100">
            <div class="card-body text-center">
                <i class="fas fa-share-alt fa-3x mb-3 text-primary"></i>
                <h3>Easy to Share</h3>
                <p>Share your custom BookLinks URL on social media, in your newsletter, or in your bio</p>
            </div>
        </div>
    </div>
</div>