// Main JavaScript for BookLinks

document.addEventListener('DOMContentLoaded', function() {
    // Auto-dismiss alerts after 5 seconds
    setTimeout(function() {
        const alerts = document.querySelectorAll('.alert-dismissible');
        alerts.forEach(function(alert) {
            const closeButton = alert.querySelector('.btn-close');
            if (closeButton) {
                closeButton.click();
            }
        });
    }, 5000);
    
    // Preview permalink
    const permalinkInput = document.getElementById('permalink');
    const appUrl = document.querySelector('.input-group-text')?.textContent || '';
    
    if (permalinkInput) {
        permalinkInput.addEventListener('input', function() {
            const permalink = this.value.toLowerCase().replace(/[^a-z0-9_-]/g, '');
            this.value = permalink;
        });
    }
    
    // Color picker preview for book customization
    const colorInputs = document.querySelectorAll('input[type="color"]');
    
    colorInputs.forEach(function(input) {
        input.addEventListener('change', function() {
            // You could add preview functionality here
            console.log(this.id + ' changed to: ' + this.value);
        });
    });
    
    // Bootstrap tooltips initialization
    const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
    if (tooltipTriggerList.length > 0) {
        const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl));
    }
});